<?php

namespace App\Http\Controllers;

use App\Models\Currency;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Validator;

class CurrencyController extends Controller
{
    public function index(): JsonResponse
    {
        $currencies = Currency::all();
        return response()->json([
            'status' => 'success',
            'data' => $currencies
        ], 200);
    }

    public function store(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'Code' => 'required|string|size:3|unique:currencies,Code',
            'Symbol' => 'required|string|max:5',
            'Exchange_rate' => 'required|numeric|min:0',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'errors' => $validator->errors()
            ], 422);
        }

        $currency = Currency::create($request->all());
        return response()->json([
            'status' => 'success',
            'data' => $currency
        ], 201);
    }

    public function show($id): JsonResponse
    {
        $currency = Currency::findOrFail($id);
        return response()->json([
            'status' => 'success',
            'data' => $currency
        ], 200);
    }

    public function update(Request $request, $id): JsonResponse
    {
        $currency = Currency::findOrFail($id);

        $validator = Validator::make($request->all(), [
            'Code' => 'sometimes|required|string|size:3|unique:currencies,Code,' . $id . ',Currency_id',
            'Symbol' => 'sometimes|required|string|max:5',
            'Exchange_rate' => 'sometimes|required|numeric|min:0',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'errors' => $validator->errors()
            ], 422);
        }

        $currency->update($request->all());
        return response()->json([
            'status' => 'success',
            'data' => $currency
        ], 200);
    }

   public function delete($id): JsonResponse
{
    $currency = Currency::findOrFail($id);
    $currency->delete();
    return response()->json([
        'status' => 'success',
        'message' => 'Currency deleted successfully'
    ], 200);
}
}
